//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of I2C communication between 2 MQ6822 ICs
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#define    uchar   unsigned char

void i2c_init();
void Write_Data(uchar addr ,uchar * data,uchar num);
void read_Data(uchar address,uchar *data,uchar bytes);

extern void delay(unsigned int Time)
{
	unsigned int i;

	for( i=Time; i>0; i-- )
	{
		__asm("nop");
		WDCDR.byte = 0x4e;				// clear wdt
	}
}

unsigned char Table[16]  = {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f};
unsigned char data[20]   = {0};
unsigned char Table1[16] = {0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0xaa,0xbb,0xcc,0xdd,0xee,0xff};
unsigned char data1[20]  = {0};

void main()
{
	i2c_init();
	WDCDR.byte = 0x4e;				// clear wdt

	while(1)
	{
		WDCDR.byte = 0x4e;				// clear wdt
		delay(50000);
		delay(50000);
		delay(50000);
		Write_Data(0x55, Table, 16);	// response only from this slave address 0x55
		delay(50000);
		delay(50000);
		read_Data(0x55, &data[0], 16);
		delay(50000);
		delay(50000);
		Write_Data(0x30, Table1, 16);	// this slave address is invalid, no response
		delay(50000);
		delay(50000);
		read_Data(0x30, &data1[0], 16);	// this slave address is invalid, no response
		delay(50000);
		delay(50000);
		delay(50000);
	}
}